function Figure4(data)
visAllAngle(data.ind); % Visualisation of all the angles
end

%% Helper function
function visAngle(dat, con)
fld_con = fieldnames(dat);
c = find(strcmp(fld_con,con));
data = dat.(fld_con{c});
titlestr = {'Without second vehicle - Yielding', 'Without second vehicle - Non-yielding','With second vehicle - Yielding', 'With second vehicle - Non-yielding'};
fld_map = fieldnames(data);

maxvals = max([max(data.(fld_map{1}).freq); max(data.(fld_map{2}).freq); max(data.(fld_map{3}).freq)]);

hold on
for m=1:length(fld_map)
    switch m
        case 1
            colour = [0, 0.45, 0.74];
        case 2
            colour = [0.85, 0.33, 0.10];
        case 3
            colour = [0.93, 0.69, 0.13];
    end
    plot(data.(fld_map{m}).val, data.(fld_map{m}).freq,'LineWidth',2,'color',colour);
end
xline(90,'--');
xlabel('Gaze yaw angle (deg)','FontSize',15,'FontWeight','bold');
ylabel({'Frequency'},'FontSize',15,'FontWeight','bold');
set(gca, 'XDir','reverse')
set(gca,'FontSize',15);
title(titlestr{c},'FontSize',15,'FontWeight','bold');
xticks(-180:45:180)
xlim([0 180]);
yticks(0:1:ceil(maxvals));
ylim([0 10]);
grid on;
legend('Baseline','LTY', 'LATY','location','northwest');
end

function visAllAngle(data)
fld_con = fieldnames(data);
figure;
for c=1:length(fld_con)
    subplot(2,2,c);
    visAngle(data, fld_con{c});
end
end